%INTRO	Introduccion a Octave.

%	Victoria Abreu-Sernandez 2-1995
%	Dpto. Tecnoloxias das Comunicacions
%	Universidade de Vigo
%

% echo off
% Borramos el espacio antes de comenzar
clear
clc
clg
format 

% Permitimos la opcion de "pause" mediante la
% variable interna "page_screen_output"



page_screen_output = "false";
silent_functions = "false";



disp('*  Bienvenido a Octave. Esta es una demostracion ')
disp('*  de algunas de las herramientas del entorno  ')
disp('*  Octave. En poco tiempo, usted podra comprobar ')
disp('*  la potencia y flexibilidad de este entorno.\n\n')

disp('*  Aquellas lineas que no van precedidas de un  ')
disp('*  asterisco (*) son comandos de Octave. \n\n')

disp('*  Presione cualquier tecla para continuar... \n\n')

pause
clc
disp('*  En primer lugar, crearemos un vector de 9 ')
disp('*  elementos al que llamaremos "a":\n\n')
disp('a = [1 2 3 4 6 4 3 4 5 ]')

a = [1 2 3 4 6 4 3 4 5 ]

disp('*  Observe como los resultados de una expresion')
disp('*  en Octave se muestran en pantalla si no se')
disp('*  aade un punto y coma al final del comando. \n\n')


disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc

disp('*  Ahora, aadimos la constante 2 a todos los ')
disp('*  elementos de nuestro vector "a" y el ')
disp('*  resultado lo almacenamos en un nuevo vector.')
disp('*  Observe como Octave no necesita ninguna ')
disp('*  manipulacion especial de vectores o matrices.\n\n')

disp('b = a + 2 ')

b = a + 2

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc

disp('*  Para crear graficas en Octave solo necesita')
disp('*  el comando "plot". Ahora vamos a representar')
disp('*  el vector "b".\n\n')

disp('grid("on")')
disp('title(\'Vector b\')')
disp('plot(b)\n')


grid("on")
title('Vector b')
plot(b)


disp('*  El comando "grid" en activo (on) genera un')
disp('*  enrejillado de la grafica.')
disp('*  El comando "plot" es el encargado de representar')
disp('*  graficamente el vector "b".')
disp('*  El titulo se inserta con el comando "title".\n\n')

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc

disp('*  Octave tambien permite otro tipo de graficas:\n\n') 


disp('xlabel(\'meses\')')
disp('ylabel(\'cantidad\')')
disp('bar(b)\n')

clg
xlabel('meses')
ylabel('cantidad')
bar(b)


disp('*  El titulo de los ejes se efectua con los ')
disp('*  comandos "xlabel" e "ylabel" y la funcion ')
disp('*  "bar" genera el diagrama de barras.\n\n') 

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc


disp('*  Ademas, Octave tambien permite usar simbolos')
disp('*  en las graficas o representaciones de tipo ')
disp('*  secuencias discretas como en el siguiente ejemplo:\n\n') 

disp('plot(b,\'^\')\n')

clg
plot(b,'^')


disp('*  Presione cualquier tecla para continuar... \n\n')
pause

disp('*  Vamos ahora a representar 2 graficas en la')
disp('*  misma ventana: \n\n') 


disp('plot(a)')
disp('hold')
disp('plot(b,\'-o\')')
disp('title(\'array a: __     array b: _.\')')
disp('hold \n')

clg
plot(a)
hold
plot(b,'-o')
title('array a: __     array b: _.')
hold

disp('*  El comando "hold" mantiene en la ventana')
disp('*  las graficas. \n\n')

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc

clg
disp('*  Octave es un entorno matematico orientado')
disp('*  al calculo matricial. Las matrices se generan  ')
disp('*  como los vectores, empleando punto y comas (;)')
disp('*  para diferenciar las filas de la matriz:   \n\n')

disp('A = [1 2 0; 2 5 -1; 4 10 -1]')

A = [1 2 0; 2 5 -1; 4 10 -1]

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  La matriz traspuesta de la matriz "A" sera:\n\n') 

disp('B = A\'')

B = A'

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc

disp('*  Multipliquemos ahora estas dos matrices.')
disp('*  Observe que Octave no necesita la ')
disp('*  especificacion de que esta tratando ')
disp('*  con matrices.\n')

disp('C = A*B') 

C = A*B

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  Tambien es posible multiplicar las dos ')
disp('*  matrices elemento a elemento, usando ')
disp('*  el operador ".*" : \n') 

disp('C = A.*B')

C = A.*B

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  Para evaluar la inversa de una matriz...\n') 

disp('X = inv(A)')

X = inv(A)

disp('*  Comprobemos que el producto entre una matriz')
disp('*  y su inversa es la matriz identidad. \n')

disp('II = inv(A)*A')

II = inv(A)*A

disp('*  Presione cualquier tecla para continuar... \n\n')

pause
clc
disp('*  Octave dispone de funciones para la mayoria')
disp('*  de los calculos matriciales. Por ejemplo,')
disp('*  la obtencion de autovalores...\n')

disp('eig(A)')

eig(A)

disp('*  Presione cualquier tecla para continuar... \n')

pause

disp('*  o la descomposicion en valores singulares \n')

disp('svd(A)')

svd(A)

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  El polinomio caracteristico de una matriz')
disp('*  A es:   det(lambda*I - A)   La funcion')
disp('*  "poly" genera un vector que contiene los ')
disp('*  coeficientes del polinomio caracteristico:\n')

disp('p = round(poly(A))')

p = round(poly(A))

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  Las raices de dicho polinomio se obtienen')
disp('*  facilmente mediante la funcion "roots".\n')

disp('roots(p)')

roots(p)

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  Octave, tambien dispone de funciones muy utiles')
disp('*  para el procesado de seales. Por ejemplo, podemos')
disp('*  realizar la convolucion de dos vectores:\n')

disp('q = conv(p,p)')

q = conv(p,p)

disp('Press any key to continue... \n\n')
pause
disp('Convolucionando de nuevo ...\n') 

disp('r = conv(p,q)')
r = conv(p,q)

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  Veamos el resultado:\n') 

disp('plot(r)\n')
plot(r)

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc

disp('*  En cualquier momento, podemos obtener el')
disp('*  listado de las variables almacenadas en')
disp('*  la memoria mediante los comandos "who"')
disp('*  o "whos" \n') 

disp('who') 

who

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  Se puede obtener el valor de una variable')
disp('*  almacenada simplemente tecleando el nombre:\n')

disp('A')
A

disp('*  Presione cualquier tecla para continuar... \n\n')

pause
format compact
clc
disp('*  En una linea puede existir mas de una')
disp('*  expresion, simplemente separandolas ')
disp('*  mediante comas (,) o punto y comas (;)')
disp('*  Ademas, si el resultado de una expresion')
disp('*  no se le asigna a una variable, este valor')
disp('*  se almacena en la variable temporal ')
disp('*  "ans". \n')

disp('sqrt(-1), log(-1), log(0)\n')

sqrt(-1), log(-1), log(0) 
disp('\n\n')

disp('*  Como ha podido observar, Octave trabaja')
disp('*  comodamente con complejos y numeros infinitos.\n\n')

disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc
disp('*  Octave tambien dispone de funciones para')
disp('*  analisis espectral, como la funcion "fft".')
disp('*  Evaluemos la FFT bidimensional de la ')
disp('*  siguiente seal:\n')

disp('A = zeros(32);')
disp('A(14:16,14:16) = ones(3);\n')
A = zeros(32);
A(14:16,14:16) = ones(3);

disp('*  Primero creamos una matriz de ceros, de')
disp('*  dimensiones 32x32 y posteriormente la ')
disp('*  parte central de esta matriz le asignamos')
disp('*  1\'s. Veamos la grafica de esta matriz.\n')

disp('mesh(A)\n')

mesh(A)


disp('*  Presione cualquier tecla para continuar... \n\n')
pause

clc
disp('*  Y ahora evaluaremos la FFT bi-dimensional')
disp('*  de A y dibujaremos su magnitud.\n')

disp('y = fft2(A);')
disp('mesh(abs(y))\n')

y = fft2(A);
mesh(abs(y))


disp('*  Presione cualquier tecla para continuar... \n\n')
pause
clc


disp('*  Gracias por su participacion en esta breve')
disp('*  introduccion a Octave.  \n\n')

% Devolvemos el valor original de la
% variable interna "page_screen_output"


