function w = cross(u,v)
% Usage: w = cross(u, v)
%
% Perform a cross product of vectors with dimension 1D to 3D.

% by Rick Niles 11/94.

if (nargin != 2)
  disp('  usage: w = cross(u,v)');
  return;
endif
if(strcmp(prefer_column_vectors, 'false'))
  u = u';
  v = v';
endif
m = rows(u);
if( all(size(u) == size(v)) && m <= 3)
  if( m==3 )  % 3-D Case.
    w(1,:) = u(2,:).*v(3,:) - u(3,:).*v(2,:);
    w(2,:) = u(3,:).*v(1,:) - u(1,:).*v(3,:);
    w(3,:) = u(1,:).*v(2,:) - u(2,:).*v(1,:);
  elseif ( m==2 ) % 2-D Case.
    w(1,:) = u(1,:).*v(2,:) - u(2,:).*v(1,:);
  elseif ( m==1 ) % 1-D Case.
    w(1,:) = u(1,:) .* v(1,:);
  endif
  if(strcmp(prefer_column_vectors, 'false'))
   w= w';
  endif
else
  error('cross: Improper size of inputs.');
endif
