function w=dot(u,v)
% usage: w = dot(u,v)
%
% Perform inner (dot) product of two vectors.

% by Rick Niles 11/94.

  if (nargin != 2)
    disp ("  usage: w = dot(u,v)");
    return;
  endif
  if (strcmp (prefer_column_vectors, "false"))
    u = u';
    v = v';
  endif
  m = rows (u);
  if (all (size (u) == size (v)))
    w = u.*v;
    if( m > 1 )
      w = sum(w);
    endif
    if (strcmp (prefer_column_vectors, "false"))
      w = w';
    endif
  else
    error ("dot: Improper size of inputs.");
  endif

endfunction