function matrix = e2dcm(e, a)
% Usage: dcm = e2dcm(e, a)
%/** Translates Euler axis/angle to Direction Cosine Matrix. **/

% by Rick Niles.

e = e(:);
if (rows(e) ~= 3 & any([1 1] ~= size(v)))
  error('e2dcm: Inputs of immproper size.');
else
  s = sin(a);
  c = cos(a);
  omc = 1 - c;
  
  matrix = zeros(3,3);
  
  %/*** Diagonals first ***/
  dv = c + e.*e*omc;
  for i=1:3
    matrix(i,i) = dv(i);
  end
  
  matrix(1,2) = e(1)*e(2)*omc + e(3)*s;
  matrix(1,3) = e(1)*e(3)*omc - e(2)*s; 
  matrix(2,3) = e(2)*e(3)*omc + e(1)*s;
  
  matrix(2,1) = matrix(1,2);
  matrix(3,1) = matrix(1,3);
  matrix(3,2) = matrix(2,3);
  
end
