function q = e2q(e, a)
% Usage: q = e2q(e, a)
%
% Convert an euler axis and angle to a quaternion.

% by Rick Niles 11/94.

if (nargin != 2)
  disp('  usage: q = e2q(e, a)');
  return;
endif
e = unit(e);
if(strcmp(prefer_column_vectors, 'false'))
  e = e';
  a = a';
endif

if(rows(e) == 3)
  q(1:3,:) = e .* sin(a/2);
  q(4,:) = cos(a/2);
else
  error('e2q: Euler axis must be 3-D.')
endif
if(strcmp(prefer_column_vectors, 'false'))
  q = q';
endif
endfunction