function mu = mag(u)
% Usage: mu = mag(u)
%
% Find the magnitude of a first order tensor.

% by Rick Niles 11/94.

if (nargin != 1)
  disp('  usage: mu = mag(u)');
  return;
endif
if(strcmp(prefer_column_vectors, 'false'))
  u = u';
endif
[m n] = size(u);

if(m > n)  % decide which method will be faster.
  for i = 1:n
    mu(i) = norm(u(:,i));
  endfor
else
  mu = sqrt(sum(u.*u));
endif
if(strcmp(prefer_column_vectors, 'false'))
  mu = mu';
endif
endfunction
