function [e, a] = q2e(q)
% Usage: [e,a] = q2e(q)
%
% Convert a quaternion to an euler axis and angle.
 
% by Rick Niles 11/94.
 
if (nargin != 1)
  disp('  usage: [e,a] = q2e(q)');
  return;
endif
if(strcmp(prefer_column_vectors, 'false'))
  q = q';
endif
if(qchk(q))
  a(1,:) = acos(q(4,:));
  e(1:3,:) = q(1:3,:) ./ sin(a([1 1 1],:));
  a=2*a;
  if(strcmp(prefer_column_vectors, 'false'))
    e = e';
    a = a';
  endif
endif
endfunction
