function r = qchk(q)
% Usage: r = qchk(q)
%
% Check for a quaternion by:
%  1) Four elements.
%  2) mag(q) ~= 1
%  3) Fourth element positive.
%  
% Return 1 if conditions met, error msg. and 0 if not.
 
% by Rick Niles 11/94.
 
if (nargin != 1)
  disp('  usage: r = qchk(q)');
  return;
endif
if(strcmp(prefer_column_vectors, 'false'))
  q = q';
endif
r = (rows(q) == 4) && all((sign(q(4,:))+1)/2) && all(abs(mag(q)-1) < 10*eps);
if(!r)
  error('qchk: Argument is not a proper quaternion.\n     Try unit(q) to fix.')
endif
endfunction
