function qout = qmult(q1,q2)
% Usage: qout = qmult(q1, q2)
%
% Perform multiplication of quaternions (4 element, first order tensors)
 
% by Rick Niles 11/94.
 
if (nargin != 2)
  disp('  usage: qout = qmult(q1,q2)');
  return;
endif
if(strcmp(prefer_column_vectors, 'false'))
  q1 = q1';
  q2 = q2';
endif
if (qchk(q1) && qchk(q2) && all(size(q1) == size(q2)))
  qout = zeros(size(q1));
  qout(1,:) = q1(1,:).*q2(4,:) + q1(2,:).*q2(3,:) ...
                             - q1(3,:).*q2(2,:) + q1(4,:).*q2(1,:);
  qout(2,:) =-q1(1,:).*q2(3,:) + q1(2,:).*q2(4,:) ...
                             + q1(3,:).*q2(1,:) + q1(4,:).*q2(2,:);
  qout(3,:) = q1(1,:).*q2(2,:) - q1(2,:).*q2(1,:) ...
                             + q1(3,:).*q2(4,:) + q1(4,:).*q2(3,:);
  qout(4,:) =-q1(1,:).*q2(1,:) - q1(2,:).*q2(2,:) ...
                             - q1(3,:).*q2(3,:) + q1(4,:).*q2(4,:);
  sm = sign(qout);
  qout = sm([4 4 4 4],:).*qout;  % assure fourth element will be positive.
else
  error('qmult: Inputs of improper size');
endif
if(strcmp(prefer_column_vectors, 'false'))
  qout = qout';
endif
