function [u, mv] = unit(v)
% Usage: [u, mv] = unit(v)
% 'u' returns a unit version of a first order tensor.
% 'mv' is the magnitude of 'v'

% by Rick Niles 11/94.

if (nargin != 1)
  disp('  unit: usage: [u, mv] = unit(v)');
  return;
endif
if(strcmp(prefer_column_vectors, 'false'))
  v = v';
endif

mv = mag(v);
u = v ./ mv(ones(rows(v),1),:);

if(strcmp(prefer_column_vectors, 'false'))
  u = u';
  mv = mv';
endif
endfunction
