function y = bin2dec (x)
  #
  # usage:  bin2dec (x)
  #
  # Returns the decimal number corresponding to the binary number in
  # quotes.  For example, bin2dec("1110") returns 14.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 12, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    error ("usage:  dec2bin (x)");
  endif

  tmp = implicit_str_to_num_ok;
  implicit_str_to_num_ok = "true";
  
  x = x - "0";
  if all( (x == 0) | (x == 1))
    y = sum(x .* 2.^( (length (x) -1):-1:0));
  else
    error ("bin2dec:  argument must be a string of zeros and ones");
  endif
  
  implicit_str_to_num_ok = tmp;
  
endfunction
