function s = blanks (n)
  
  # usage:  blanks (n)
  #
  # Returns a string of n blanks.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 94/10/08
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  blanks (n)");
  endif
  
  if !( is_scalar (n) && (n > 0) && (n == round (n)) )
    error ("blanks:  n has to be a positive integer");
  endif
  
  tmp = implicit_str_to_num_ok;
  implicit_str_to_num_ok = "true";
  
  s = setstr (ones (1, n) * " ");

  implicit_str_to_num_ok = tmp;
  
endfunction
  



