function t = deblank (s)
  
  # usage:  deblank (s)
  #
  # Remove trailing blanks from the string s.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  deblank (s)");
  endif
  
  if !(isstr (s))
    error ("deblank:  s must be a string");
  endif

  tmp = implicit_str_to_num_ok;
  implicit_str_to_num_ok = "true";

  len = length (s);
  if (len == 0)
    t = s;
  else
    s = s - " ";
    k = min (find (s(len:-1:1)));
    t = setstr (s(1:(len-k+1)) + " ");
  endif
  
  implicit_str_to_num_ok = tmp;
  
endfunction
