function y = dec2bin (x)

  # usage:  dec2bin (x)
  #
  # Returns the binary number corresponding to the nonnegative integer
  # x.  For example, dec2bin(14) returns "1110".
  #
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 12, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    error ("usage:  dec2bin (x)");
  endif
  
  if !( (x == round(x)) && (x >= 0) )
    error ("dec2bin:  x must be a nonnegative integer");
  endif
  
  y = [];
  while (x >= 2)
    z = fix (x ./ 2);
    y = [y, x - 2 * z];
    x = z;
  endwhile

  y = fliplr ([y, x]);
  
  tmp = implicit_str_to_num_ok;
  implicit_str_to_num_ok = "true";

  y = setstr(y + "0");
  
  implicit_str_to_num_ok = tmp;
  
endfunction
    
