function h = dec2hex (d)
  # 
  # usage:  dec2hex (d)
  #
  # Returns the hex number corresponding to the decimal number d.  For
  # example, dec2hex(2748) returns "abc". 
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 4, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if !( is_scalar(d) && (rem(d, 1) == 0) )
    error ("dec2hex:  d must be an integer.");
  endif
  
  h = sprintf ("%x", d);
  
endfunction
