function v = findstr (s, t)

  # usage:  findstr (s, t)
  #
  # Returns the vector of all positions where an occurence of the
  # shorter of the two trings s and t in the longer starts.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 18, 1994
  # Copyright Dept of Statistics and Probability Theory TU Wien

  if !( isstr(s) && isstr(t) )
    error ("findstr:  both arguments must be strings");
  endif
  
  if (length (s) < length (t))
    u = s; s = t; t = u;
  endif
  
  tmp = implicit_str_to_num_ok;
  implicit_str_to_num_ok = "true";
  s = s + 0;
  t = t + 0;
  
  ind = 1 : length(t);
  v   = [];
  for k = 1 : (length (s) - length (t) +1)
    if (s (ind + k - 1) == t)
      v = [v, k];
    endif
  endfor
  
  implicit_str_to_num_ok = tmp;
  
endfunction
