function n = index (s, t)

  # usage:  index (s, t)
  #
  # Returns the position of the first occurence of the string t in the
  # string s or 0 if no occurence is found.

  # This one is named after AWK.  Perhaps it should be strstr instead?

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 4, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if !( isstr(s) && isstr(t) )
    error ("index:  expecting string arguments");
  endif
  
  l_s = length (s);
  l_t = length (t);
  if (l_t <= l_s)
    for n = 1 : (l_s-l_t+1)
      if strcmp (substr (s, n, l_t), t) 
	return;
      endif
    endfor
  endif
  n = 0;
  
endfunction
