function m = split (s, t)
  
  # usage:  m = split (s, t)
  #
  # Divides the string s into pieces separated by t, and stores the
  # pieces as the rows of m (padded with blanks to form a valid
  # matrix).
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 2)
    error ("usage:  split (s, t)");
  endif
  
  if !( isstr(s) && isstr(t) )
    error ("split:  both s and t must be strings");
  endif
  
  tme = empty_list_elements_ok;
  tmi = implicit_str_to_num_ok;
  empty_list_elements_ok = "true";
  implicit_str_to_num_ok = "true";

  l_s = length (s);
  l_t = length (t);
  
  if (l_s < l_t)
    error ("split:  s must not be shorter than t");
  endif
  
  if (l_t == 0)
    ind = 1 : (l_s + 1);
  else
    ind = findstr (s, t);
    if (length (ind) == 0)
      m = s;
      return;
    endif
    ind = [1 - l_t, ind, l_s + 1];
  endif
  
  s   = s + 0;
  cmd = "";
  
  for k = 1 : (length (ind) - 1)
    range = (ind (k) + l_t) : (ind (k + 1) - 1);
    if (length (range) == 0)
      cmd = [cmd, sprintf("\"\", ")];
    else
      cmd = [cmd, sprintf("\"%s\", ", setstr (s (range)))];
    endif
  endfor
  cmd = substr (cmd, 1, length (cmd) - 2)
    
  m = eval (["str2mat(", cmd, ");"]);
  
  empty_list_elements_ok = tme;
  implicit_str_to_num_ok = tmi;

endfunction
