function m = str2mat (...)
  
  # usage:  m = str2mat (s1, ...)
  #
  # Forms the matrix m containing the strings s1, ... as its rows.
  # Each string is padded with blanks in order to form a valid matrix.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin == 0)
    error ("usage:  str2mat (s1,  ...)");
  endif
  
  tme = empty_list_elements_ok;
  tmi = implicit_str_to_num_ok;
  empty_list_elements_ok = "true";
  implicit_str_to_num_ok = "true";

  r_m = nargin;
  len = zeros (r_m, 1);

  for k = 1 : r_m
    s = va_arg ();
    if !(isstr (s))
      error ("str2mat:  all arguments must be strings");
    endif
    len (k) = length (s);
    eval (sprintf ("s%d = \"%s\";", k, s));
  endfor
  
  c_m = max (len);
  m   = zeros (r_m, c_m);
  if (c_m > 0)
    for k = 1 : r_m; 
      m(k, :) = [eval (sprintf ("s%d;", k)), ...
	  " " * ones (1, c_m - len (k))];
    endfor
  endif
    
  empty_list_elements_ok = tme;
  implicit_str_to_num_ok = tmi;
  
endfunction
