function t = strrep (s, x, y)
  
  # usage:  strrep (s, x, y)
  #
  # Replace all occurences of the substring x of the string s with the
  # string y.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 94/10/11
  # Copyright Department of Statistics and Probability Theory TU Wien
  
  if (nargin <> 3)
    error ("usage:  strrep (s, x, y)");
  endif
  
  if !(isstr (s) && isstr (x) && isstr (y))
    error ("strrep:  all arguments must be strings");
  endif
  
  if ((length (x) > length (s)) || (isempty (x)))
    t = s;
    return;
  endif
  
  ind = findstr (s, x);
  len = length (ind);
  if (len == 0)
    t   = s;
  else
    tmp = implicit_str_to_num_ok;
    implicit_str_to_num_ok = "true";

    # This is ugly but currently we cannot select directly from a
    # string 
    s   = s + 0;
    x   = x + 0;
    y   = y + 0;

    l_x = length (x);
    t   = [s (1 : ind(1) - 1), y];
    for k = 1 : len - 1
      t = [t, s (ind(k) + l_x : ind(k+1) - 1), y];
    endfor
    t   = [t, s (ind(len) + l_x : length (s))];
    t   = setstr (t);

    implicit_str_to_num_ok = tmp;
  endif
  
endfunction

