function t = substr (s, start, length)

  # usage:  substr (s, start, length)
  #
  # Returns the length-long substring of the string s starting at
  # character number start.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 4, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if !(isstr (s))
    error ("substr:  expecting string argument");
  endif

  tmp = implicit_str_to_num_ok;
  implicit_str_to_num_ok = "true";

  s = s + 0;
  t = setstr( s (start : (start + length - 1)));
  
  implicit_str_to_num_ok = tmp;
  
endfunction
