function t = toupper (s)

  # usage:  toupper (s)
  #
  # Returns a copy of the string s, with each lower-case character
  # replaced with the corresponding upper-case one;  nonalphabetic
  # characters are left unchanged.
  #
  # E.g., `toupper ("MiXeD cAsE 123")' returns "MIXED CASE 123".

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 4, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if !(isstr (s))
    error("toupper:  expecting string argument");
  endif
  
  tmp = implicit_str_to_num_ok;
  implicit_str_to_num_ok = "true";
  t = setstr (s + ("A" - "a") * ((s >= "a") & (s <= "z")));
  implicit_str_to_num_ok = tmp;
  
endfunction
