function b = bincoeff (n, k)
  
# usage:  bincoeff (n, k)
#
# Returns the binomial coefficient of n and k.

# Written by KH (Kurt.Hornik@neuro.tuwien.ac.at) on 94/10/08
# Updated by KH (Kurt.Hornik@neuro.tuwien.ac.at) on 94/10/22
# Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 2)
    usage ("bincoeff (n, k)");
  endif
  
  [retval, n, k] = common_size (n, k);
  if (retval > 0)
    error ("bincoeff:  n and k must be of common size or scalars");
  endif
  
  [r, c] = size (n);
  s = r * c;
  n   = reshape (n, s, 1);
  k   = reshape (k, s, 1);
  b   = zeros (s, 1);
  
  ind = find (!(k >= 0) | (k != real (round (k))) | isnan (n));
  if any (ind)
    b(ind) = NaN * ones (length (ind), 1);
  endif
  
  ind = find (k == 0);
  if any (ind)
    b(ind) = ones (length (ind), 1);
  endif

  ind = find ((k > 0) & ((n == real (round (n))) & (n < 0)));
  if any (ind)
    b(ind) = (-1) .^ k(ind) .* exp (lgamma (abs (n(ind)) + k(ind)) ...
	- lgamma (k(ind) + 1) - lgamma (abs (n(ind))));
  endif
  
  ind = find ((k > 0) & ((n != real (round (n))) | (n >= k)));
  if (length (ind) > 0)
    b(ind) = exp (lgamma (n(ind) + 1) - lgamma (k(ind) + 1) ...
	- lgamma (n(ind) - k(ind) + 1));
  endif
  
  # clean up rounding errors
  ind = find (n == round (n));
  if any (ind)
    b(ind) = round (b(ind));
  endif
  
  b   = reshape (b, r, c);
  
endfunction

