function [errorcode, ...] = common_size (...)
  
  # usage:  [errorcode, y_1, ...] = common_size (x_1, ...)
  #
  # Determine if all input arguments are either scalar or of common
  # size.  In this case, errorcode is zero, and y_i is a matrix of the
  # common size with all entries equal to x_i if this is a scalar or
  # x_i otherwise.
  # Otherwise, errorcode is 1, and y_i is x_i.
  
  # For example,
  #    [errorcode, a, b] = common_size ([1 2; 3 4], 5)
  # returns errorcode = 0, a = [1 2, 3 4], b = [5 5; 5 5].
  
  # This is useful for implementing functions where arguments can
  # either be scalars or of common size.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/10/15
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin < 2)
    error ("common_size:  only makes sense if nargin >= 2");
  endif

  va_start ();
  for k = 1 : nargin
    s(k, :) = size (va_arg ());
  endfor
  
  m = max (s);
  if any (any ((s != 1)') & any ((s != ones (nargin, 1) * m)'))
    errorcode = 1;
    va_start ();
    for k = 1 : nargin
      vr_val (va_arg ());
    endfor
  else
    errorcode = 0;
    va_start ();
    for k = 1 : nargin
      if (prod (s(k, :)) == 1)
	vr_val (va_arg () * ones (m));
      else
	vr_val (va_arg ());
      endif
    endfor
  endif
  
endfunction
    