function x = diff (x, k)
  
# usage:  diff (x [, k])
#
# If x is a vector of length n, diff (x) is the vector of first
# differences x(2) - x(1), ..., x(n) - x(n-1).
# If x is a matrix, diff (x) is the matrix of column differences.
# diff (x, k), where k is a nonnegative integer, returns the k-th
# differences.
  
# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/02/02
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1995/02/06
# Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin == 1)
    k = 1;
  elseif (nargin == 2)
    if !(is_scalar (k) && (k == round (k)) && (k >= 0))
      error ("diff:  k must be a nonnegative integer");
    elseif (k == 0)
      return;
    endif
  else
    usage ("diff (x [, k]");
  endif
  
  if isstr (x)
    error ("diff:  symbolic differentiation not (yet) supported");
  elseif is_vector (x)
    n = length (x);
    if (n <= k)
      x = [];
    else
      for i = 1 : k
	x = x (2 : (n - i + 1)) - x (1 : (n - i));
      endfor
    endif
  elseif is_matrix (x)
    n = rows (x);
    if (n <= k)
      x = [];
    else
      for i = 1 : k
	x = x (2 : (n - i + 1), :) - x (1: (n - i), :);
      endfor
    endif
  else
    x = [];
  endif

endfunction
    