function n = nextpow2 (x)
  
  # usage:  nextpow2 (x)
  #
  # If x is a scalar, returns the first integer n such that 
  # 2^n >= abs (x). 
  # If x is a vector, return nextpow2 (length (x)). 

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 94/10/07
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error("usage:  nextpow2 (x)");
  endif

  if is_vector (x)
    x = length (x);
  elseif !(is_scalar (x))
    error ("nextpow2:  x must be a scalar or a vector");
  endif
  
  [f, n] = log2 (abs (x));
  if (f == 0.5)
    n = n - 1;
  endif
  
endfunction
  



