function y = shift (x, b)
  
  # usage: y = shift (x, b)
  #
  # If x is a vector, perform a circular shift of length b of the
  # elements of x.
  # If x is a matrix, do the same for each column of x.

  # Written by AW (Andreas.Weingessel@ci.tuwien.ac.at) on Sep 14, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  shift (X, b)");
  endif

  [nr nc] = size (x);
  
  if ((nr == 0) || (nc == 0))
    error ("shift:  x must not be empty");
  elseif (nr == 1)
    x = x'; nr = nc; nc = 0;
  endif

  if !(is_scalar (b) && (b == round (b)))
    error ("shift:  b must be an integer");
  endif

  if (b >= 0)
    b = rem (b, nr);
    y = [x (nr - b + 1 : nr, :); x (1 : nr - b, :)];
  elseif (b < 0)
    b = rem (abs (b), nr);
    y = [x (b + 1 : nr, :); x (1 : b, :)];
  endif
  
  if (nc == 0)
    y = reshape (y, 1, nr);
  endif

endfunction
