function A = sieve (n)
# Erathostenes sieve algorithm: find all primes not greater than n

# Put in the public domain by Francesco Potorti` <pot@cnuce.cnr.it> 1995


  if (!is_scalar(n) || n < 1 || n != round(n))
    error ("n should be a positive integer\n");
  endif
  if (n <= 3)
    A = [2:n];
    return;
  endif

  # Make an array of ones, one for the number 2 and one for each odd number
  # greater than 2 and not greater than n.  The natural corresponding to the
  # i-th one (i>2) is then 2*n-1.  Put a zero where the corresponding
  # natural is not a prime.

  lp = floor ((n+1)/2);
  prime = ones (1, lp);
  for i = 2:(sqrt(n)+1)/2
    if prime(i)
      Ni = 2*i-1;
      range = (Ni*Ni+1)/2:Ni:lp;
      prime(range) = zeros (size (range));
    endif
  endfor
  
  A = 2 * find (prime) - 1;
  A(1) = 2;
endfunction





