function z = xor (x, y)

# usage:  xor (x, y)
#
# Returns the "exclusive or" of the entries of x and y.
# For boolean expressions x and y, xor (x, y) is true iff either x
# or y is true.

# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/09/16
# Copyright Dept of Statistics and Probability Theory TU Wien

  if (nargin != 2)
    usage ("xor (x, y)");
  endif
  
  if (any (size (x) != size (y)))
    error("xor:  x and y must have the same size");
  endif
  
  z = (x | y) - (x & y);
  
endfunction
