function cdf = beta_cdf (x, a, b)
  
  # usage:   beta_cdf (x, a, b)
  #
  # For each element of x, returns the CDF at x of the beta distribution
  # with parameters a and b, i.e., PROB( beta(a,b) <= x).

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jun 10, 1993
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 3)
    error("usage:  beta_cdf (a, b, x)");
  endif

  [retval, x, a, b] = common_size (x, a, b);
  if (retval > 0)
    error ("beta_cdf:  x, a and b must be of common size or scalar");
  endif
  
  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, s, 1);
  a   = reshape (a, s, 1);
  b   = reshape (b, s, 1);
  cdf = zeros (s, 1);
  
  k = find (!(a > 0) | !(b > 0) | isnan (x));
  if any (k)
    cdf (k) = NaN * ones (length (k), 1);
  endif
  
  k = find ((x >= 1) & (a > 0) & (b > 0));
  if any (k)
    cdf (k) = ones (length (k), 1);
  endif
  
  k = find ((x > 0) & (x < 1) & (a > 0) & (b > 0));
  if any (k)
    cdf (k) = betai (a(k), b(k), x(k));
  endif
  
  cdf = reshape (cdf, r, c);
  
endfunction
