function pdf = beta_pdf (x, a, b)
  
  # usage:   beta_pdf (x, a, b)
  #
  # For each element of x, returns the PDF at x of the beta
  # distribution with parameters a and b.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 10, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 3)
    error("usage:  beta_pdf (a, b, x)");
  endif

  [retval, x, a, b] = common_size (x, a, b);
  if (retval > 0)
    error ("beta_pdf:  x, a and b must be of common size or scalar");
  endif

  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, s, 1);
  a   = reshape (a, s, 1);
  b   = reshape (b, s, 1);
  pdf = zeros (s, 1);
  
  k = find (!(a > 0) | !(b > 0) | isnan (x));
  if any (k)
    pdf (k) = NaN * ones (length (k), 1);
  endif

  k = find ((x > 0) & (x < 1) & (a > 0) & (b > 0));
  if any (k)
    pdf(k) = exp ((a(k) - 1) .* log (x(k)) ...
	+ (b(k) - 1) .* log (1 - x(k))) ./ beta (a(k), b(k));  
  endif

  pdf = reshape (pdf, r, c);
  
endfunction
