function cdf = binomial_cdf (x, n, p)
  
  # usage:   binomial_cdf (x, n, p)
  #
  # For each element of x, compute the CDF at x of the binomial
  # distribution with parameters n and p.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jun 10, 1993
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 3)
    error ("usage:  binomial_cdf (x, n, p)");
  endif
  
  [retval, x, n, p] = common_size (x, n, p);
  if (retval > 0)
    error (["binomial_cdf:  ", ...
	"x, n and p must be of common size or scalar"]);
  endif
  
  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, 1, s);
  n   = reshape (n, 1, s);
  p   = reshape (p, 1, s);
  cdf = zeros (1, s);

  k = find (isnan (x) | !(n >= 0) | (n <> round (n)) ...
      | !(p >= 0) | !(p <= 1));
  if any (k)
    cdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x >= n) & (n >= 0) & (n == round (n)) ...
      & (p >= 0) & (p <= 1)); 
  if any (k)
    cdf(k) = ones (1, length (k));
  endif
  
  k = find ((x >= 0) & (x < n) & (n == round (n)) ...
      & (p >= 0) & (p <= 1));
  if any (k)
    tmp = floor (x(k));
    cdf(k) = 1 - betai (tmp + 1, n(k) - tmp, p(k));
  endif
  
  cdf = reshape (cdf, r, c);
  
endfunction
