function pdf = binomial_pdf (x, n, p)
  
  # usage:   binomial_pdf (x, n, p)
  #
  # For each element of x, compute the probability density function
  # (PDF) at x of the binomial distribution with parameters n and p.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jun 10, 1993
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 3)
    error ("usage:  binomial_pdf (x, n, p)");
  endif

  [retval, x, n, p] = common_size (x, n, p);
  if (retval > 0)
    error (["binomial_pdf:  ", ...
	"x, n and p must be of common size or scalar"]);
  endif
  
  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, 1, s);
  n   = reshape (n, 1, s);
  p   = reshape (p, 1, s);
  cdf = zeros (1, s);

  k = find (isnan (x) | !(n >= 0) | (n <> round (n)) ...
      | !(p >= 0) | !(p <= 1));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x >= 0) & (x <= n) & (x == round (x)) ...
      & (n == round (n)) & (p >= 0) & (p <= 1));
  if any (k)
    pdf(k) = bincoeff (n(k), x(k)) .* (p(k) .^ x(k)) ...
	.* ((1 - p(k)) .^ (n(k) - x(k)));
  endif
 
  pdf = reshape (pdf, r, c);
  
endfunction
