function cdf = cauchy_cdf (x)
  
  # usage:   cauchy_cdf (x)
  #
  # For each element of x, compute the cumulative distribution
  # function (CDF) at x of the Cauchy distribution.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  cauchy_cdf (x)");
  endif
  
  # This could simply be implemented as
  # cdf = t_cdf (x, 1);
  # However, the following is much faster:
  
  cdf = 0.5 + atan (x) / pi;
  
endfunction
