function pdf = cauchy_pdf (x)
  
  # usage:   cauchy_pdf (x)
  #
  # For each element of x, compute the probability density function
  # (PDF) at x of the Cauchy distribution.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 1)
    error ("usage:  cauchy_pdf (x)");
  endif

  # This could simply be implemented as
  # pdf = t_pdf (x, 1);
  # However, the following is much faster:

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  pdf = zeros (1, s);
  
  k = find (isnan (x));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x > -Inf) & (x < Inf));
  if any (k)
    pdf(k) = (1 ./ (1 + x(k) .^ 2)) / pi;
  endif
  
  pdf = reshape (pdf, r, c);
  
endfunction
