function rnd = cauchy_rnd (r, c)
  
  # usage:  cauchy_rnd (r, c)
  #
  # Return an r by c matrix of random numbers from the Cauchy
  # distribution.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/11/01
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  cauchy_rnd (r, c)");
  endif

  if !(is_scalar (r) && (r > 0) && (r == round (r)))
    error ("cauchy_rnd:  r must be a positive integer");
  endif
  if !(is_scalar (c) && (c > 0) && (c == round (c)))
    error ("cauchy_rnd:  c must be a positive integer");
  endif

  current_distribution = rand ("dist");
  rand ("uniform");
  rnd = - cot (pi * rand (r, c));
  rand (current_distribution);
  
endfunction
