function retval = center (x)
  
  # usage:  center(x)
  #
  # If x is a vector, subtract its mean.
  # If x is a matrix, do the above for each column.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 2, 1994. 
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    error ("usage:  center(x)");
  endif

  if is_vector (x)
    retval = x - mean(x);
  elseif is_matrix (x)
    retval = x - ones (rows (x), 1) * mean(x);
  else
    error ("center:  x must be a vector or a matrix.");
  endif

endfunction