function cdf = chisquare_cdf (x, n)
  
  # usage:  chisquare_cdf (x, n)
  #
  # For each element of x, compute the cumulative distribution
  # function (CDF) at x of the chisquare distribution with n degrees 
  # of freedom. 
  
  # Written by TT (Teresa.Twaroch@ci.tuwien.ac.at) on Jun 3, 1993.
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  chisquare_cdf (x, n)");
  endif

  [retval, x, n] = common_size (x, n);
  if (retval > 0)
    error (["chisquare_cdf:  ", ...
	"x and n must be of common size or scalar"]);
  endif
  
  cdf = gamma_cdf (x, n / 2, 1 / 2);
  
  # should we really only allow for positive integer n?
  k = find (n != round (n));
  if any (k)
    fprintf (stderr, ...
	"WARNING:  n should be positive integer\n");
    [r, c] = size (x);
    cdf = reshape (cdf, 1, r * c);
    cdf(k) = NaN * ones (1, length (k));
    cdf = reshape (cdf, r, c);  
  endif

endfunction
