function inv = chisquare_inv (x, n)
  
  # usage:  chisquare_inv (x, n)
  #
  # For each element of x, compute the quantile (the inverse of the
  # CDF) at x of the chisquare distribution with n degrees of freedom.
  
  # Written by TT (Teresa.Twaroch@ci.tuwien.ac.at) on Jun 3, 1993.
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  chisquare_inv (x, n)");
  endif

  [retval, x, n] = common_size (x, n);
  if (retval > 0)
    error ("chisquare_inv:  x and n must be of common size or scalar");
  endif

  inv = gamma_inv (x, n / 2, 1 / 2);
  
  # Allow only for (positive) integer n.
  k = find (n != round (n));
  if any (k)
    fprintf (stderr, ...
	"WARNING:  n should be positive integer\n");
    [r, c] = size (x);
    inv = reshape (inv, 1, r * c);
    inv(k) = NaN * ones (1, length (k));
    inv = reshape (inv, r, c);
  endif
  
endfunction
