function pdf = chisquare_pdf (x, n)
  
  # usage:  chisquare_pdf (x, n)
  #
  # For each element of x, compute the probability density function
  # (PDF) at x of the chisquare distribution with k degrees of
  # freedom. 

  # Written by TT (Teresa.Twaroch@ci.tuwien.ac.at) on Jun 3, 1993
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  chisquare_pdf (x, n)");
  endif

  [retval, x, n] = common_size (x, n);
  if (retval > 0)
    error (["chisquare_pdf:  ", ...
	"x and n must be of common size or scalar"]);
  endif
  
  pdf = gamma_pdf (x, n / 2, 1 / 2);
  
  # should we really only allow for positive integer n?
  k = find (n != round (n));
  if any (k)
    fprintf (stderr, ...
	"WARNING:  n should be positive integer\n");
    [r, c] = size (x);
    pdf = reshape (pdf, 1, r * c);
    pdf(k) = NaN * ones (1, length (k));
    pdf = reshape (pdf, r, c);
  endif
  
endfunction
