function [pval, chisq, df] = chisquare_test_independence (X)
  
  # usage:  [pval, chisq, df] = chisquare_test_independence (X)
  #
  # Perform a chi-square test for indepence based on the contingency 
  # table X.
  #
  # Under the null hypothesis of independence, chisq approximately has 
  # a chi-square distribution with df degrees of freedom.
  # pval is the p-value (1 minus the CDF of this distribution at chisq)
  # of the test.
  # 
  # If no output argument is given, the p-value is displayed.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Jul 31, 1994. 
  # Last updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 13, 1994. 
  # Copyright Dept of Probability Theory and Statistics TU Wien

  [r s] = size (X);
  df    = (r - 1) * (s - 1);
  n     = sum (sum (X));
  Y     = sum (X')' * sum (X) / n;
  X     = (X - Y).^2 ./ Y;
  chisq = sum (sum (X));
  pval  = 1 - chisquare_cdf (chisq, df);
  
  if (nargout == 0)
    printf("  pval:  %g\n", pval);
  endif

endfunction