function retval = corrcoef (x, y)

# usage: corrcoef (x [, y])
#
# The (i,j)-th entry of corrcoef (x, y) is the correlation between the
# i-th variable in x and the j-th variable in y.
# For matrices, each row is an observation and each column a variable;
# vectors are always observations and may be row or column vectors.
# corrcoef (x) is corrcoef (x, x).

# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) March 1993
# Dept of Probability Theory and Statistics TU Wien, Austria
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) February 1995

  if (nargin < 1 || nargin > 2)
    usage ("corrcoef (x [, y])");
  endif

  if (nargin == 2)
    c = cov (x, y);
    s = std (x)' * std (y);
    retval = c ./ s;
  elseif (nargin == 1)
    c = cov (x);
    s = diag (c);
    retval = c ./ sqrt (s * s');
  endif

endfunction
