function c = cov (x, y)

# usage: cov (x [, y])
#
# The (i,j)-th entry of cov (x, y) is the covariance between the i-th
# variable in x and the j-th variable in y.
# For matrices, each row is an observation and each column a variable;
# vectors are always observations and may be row or column vectors.
# cov (x) is cov (x, x).

# Written by KH (Kurt.Hornik@ci.tuwien.ac.at) March 1993
# Dept of Probability Theory and Statistics TU Wien, Austria
# Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) February 1995

  if (nargin < 1 || nargin > 2)
    usage ("cov (x [, y])");
  endif

  if (rows (x) == 1)
    x = x';
  endif
  n = rows (x);

  if (nargin == 2)
    if (rows (y) == 1)
      y = y';
    endif
    if (rows (y) <> n)
      error ("cov: x and y must have the same number of observations."); 
    endif
    x = x - ones (n, 1) * sum (x) / n;
    y = y - ones (n, 1) * sum (y) / n;
    c = conj (x' * y / (n - 1));
  elseif (nargin == 1)
    x = x - ones (n, 1) * sum (x) / n;
    c = conj (x' * x / (n - 1));
  endif

endfunction
