function y = erfinv (x)
  
  # usage:  erfinv (x)
  #
  # Computes the inverse of the error function erf.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Sep 27, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 24, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien
  
  if (nargin <> 1)
    error ("usage:  erfinv (x)");
  endif
  
  [m, n] = size (x);  
  x = reshape (x, m * n, 1);
  y = zeros (m * n, 1);
  
  k = find ((x < -1) | (x > 1) | isnan (x));
  if any (k)
    y(k) = NaN * ones (length (k), 1);
  endif
  
  y (find (x == -1)) = (-Inf) * ones (sum (x == -1), 1);
  y (find (x == 1)) = Inf * ones (sum (x == 1), 1);
  
  k = find ((x > -1) & (x < 1));
  if any (k)
    c     = sqrt (pi) / 2;
    z_old = ones (length (k), 1);
    z_new = zeros (length (k), 1);
    x     = x(k);
    while (any (abs (z_new - z_old) > eps))
      z_old = z_new;
      z_new = z_old - c * (erf (z_old) - x) .* exp (z_old .^ 2);
    endwhile
    y(k)  = z_new;
  endif
  
  y = reshape (y, m, n);
    
endfunction
