function cdf = exponential_cdf (x, l)
  
  # usage:  exponential_cdf (x, lambda)
  #
  # For each element of x, compute the cumulative distribution
  # function (CDF) at x of the exponential distribution with parameter
  # lambda. 
  
  # The arguments can be of common size or scalar.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  exponential_cdf (x, lambda)");
  endif
  
  [retval, x, l] = common_size (x, l);
  if (retval > 0)
    error (["exponential_cdf:  ",
	"x and lambda must be of common size or scalar"]);
  endif
  
  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  l = reshape (l, 1, s);
  cdf = zeros (1, s);
  
  k = find (isnan (x) | !(l > 0));
  if any (k)
    cdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x == Inf) & (l > 0));
  if any (k)
    cdf(k) = ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < Inf) & (l > 0));
  if any (k)
    cdf (k) = 1 - exp (- l(k) .* x(k));
  endif

  cdf = reshape (cdf, r, c);
  
endfunction
