function inv = exponential_inv (x, l)
  
  # usage:  exponential_inv (x, lambda)
  #
  # For each element of x, compute the quantile (the inverse of the
  # CDF) at x of the exponential distribution with parameter lambda.
  
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 31, 1994
  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  exponential_inv (x, lambda)");
  endif
  
  [retval, x, l] = common_size (x, l);
  if (retval > 0)
    error (["exponential_inv:  ", ...
	"x and lambda must be of common size or scalar"]);
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  l = reshape (l, 1, s);
  inv = zeros (1, s);
  
  k = find (!(l > 0) | (x < 0) | (x > 1) | isnan (x));
  if any (k)
    inv(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x == 1) & (l > 0));
  if any (k)
    inv(k) = Inf * ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < 1) & (l > 0));
  if any (k)
    inv(k) = - log (1 - x(k)) ./ l(k);
  endif

  inv = reshape (inv, r, c);
  
endfunction
