function pdf = exponential_pdf (x, l)
  
  # usage:  exponential_pdf (x, lambda)
  #
  # For each element of x, compute the probability density function
  # (PDF) of the exponential distribution with parameter lambda.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 13, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 26, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 2)
    error ("usage:  exponential_pdf (x, lambda)");
  endif
  
  [retval, x, l] = common_size (x, l);
  if (retval > 0)
    error (["exponential_pdf:  ", ...
	"x and lambda must be of common size or scalar"]);
  endif

  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  l = reshape (l, 1, s);
  pdf = zeros (1, s);

  k = find (!(l > 0) | isnan (x));
  if any (k)
    pdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < Inf) & (l > 0));
  if any (k)
    pdf(k) = l(k) .* exp (- l(k) .* x(k));
  endif

  pdf = reshape (pdf, r, c);
  
endfunction
