function inv = f_inv (x, m, n)

  # usage:  f_inv (x, m, n)
  #
  # For each component of x, compute the quantile (the inverse of the
  # CDF) at x of the F distribution with parameters m and n.

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on 1994/10/26
  # Copyright Department of Probability Theory and Statistics TU Wien

  if (nargin != 3)
    error ("usage:  f_inv (x, m, n)");
  endif

  [retval, x, m, n] = common_size (x, m, n);
  if (retval > 0)
    error ("f_inv:  x, m and n must be of common size or scalar");
  endif
  
  [r, c] = size (x);
  s = r * c;
  x = reshape (x, 1, s);
  m = reshape (m, 1, s);
  n = reshape (n, 1, s);
  inv = zeros (1, s);

  k = find ((x < 0) | (x > 1) | isnan (x) | !(m > 0) | !(n > 0));
  if any (k)
    inv(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x == 1) & (m > 0) & (n > 0));
  if any (k)
    inv(k) = Inf * ones (1, length (k));
  endif
  
  k = find ((x > 0) & (x < 1) & (m > 0) & (n > 0));
  if any (k)
    inv(k) = (1 ./ beta_inv (1 - x(k), n(k) / 2, m(k) / 2) - 1) ...
	.* n(k) ./ m(k);
  endif

  # should we really only allow for positive integer m, n?
  k = find ((m != round (m)) | (n != round (n)));
  if any (k)
    fprintf (stderr, ...
	"WARNING:  m and n should be positive integers\n");
    inv(k) = NaN * ones (1, length (k));
  endif
  
  inv = reshape (inv, r, c);
  
endfunction