function pdf = gamma_pdf (x, a, b)
  
  # usage:  gamma_pdf (x, a, b)
  #
  # For each element of x, return the probability density function
  # (PDF) at x of the Gamma distribution with parameters a and b.
  
  # Written by TT (Teresa.Twaroch@ci.tuwien.ac.at) on Jun 3, 1993
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Aug 12, 1994
  # Updated by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 22, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin != 3)
    error ("usage:  gamma_pdf (x, a, b)");
  endif

  [retval, x, a, b] = common_size (x, a, b);
  if (retval > 0)
    error ("gamma_pdf:  x, a and b must be of common size or scalars");
  endif

  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, s, 1);
  a   = reshape (a, s, 1);
  b   = reshape (b, s, 1);
  pdf = zeros (s, 1);
  
  k = find (!(a > 0) | !(b > 0) | isnan (x));
  if any (k)
    pdf (k) = NaN * ones (length (k), 1);
  endif

  k = find ((x > 0) & (a > 0) & (b > 0));
  if any (k)
    pdf (k) = (b(k) .^ a(k)) .* (x(k) .^ (a(k) - 1)) ...
	.* exp(-b(k) .* x(k)) ./ gamma (a(k));
  endif

  pdf = reshape (pdf, r, c);
  
endfunction
