function cdf = geometric_cdf (x, p)
  
  # usage:   geometric_cdf (x, p)
  #
  # For each element of x, compute the CDF at x of the geometric
  # distribution with parameter p. 

  # Written by KH (Kurt.Hornik@ci.tuwien.ac.at) on Oct 30, 1994
  # Copyright Dept of Probability Theory and Statistics TU Wien

  if (nargin <> 2)
    error ("usage:  geometric_cdf (x, p)");
  endif

  [retval, x, p] = common_size (x, p);
  if (retval > 0)
    error (["geometric_cdf:  ", ...
	"x and p must be of common size or scalar"]);
  endif
  
  [r, c] = size (x);
  s = r * c;
  x   = reshape (x, 1, s);
  p   = reshape (p, 1, s);
  cdf = zeros (1, s);

  k = find (isnan (x) | !(p >= 0) | !(p <= 1));
  if any (k)
    cdf(k) = NaN * ones (1, length (k));
  endif
  
  k = find ((x == Inf) & (p >= 0) & (p <= 1));
  if any (k)
    cdf(k) = ones (1, length (k));
  endif
  
  k = find ((x >= 0) & (x < Inf) & (x == round (x)) ...
      & (p > 0) & (p <= 1));
  if any (k)
    cdf(k) = 1 - ((1 - p(k)) .^ (x(k) + 1));
  endif
 
  cdf = reshape (cdf, r, c);
  
endfunction
